//#12.00Aa WDEncode.JS
//VersionVI: 30F120034d
// Le seul support technique disponible pour cette librairie est
// accessible a travers le service "Assistance Directe".

// Attention a ne pas mettre d'accent dans ce fichier COMMENTAIRES inclus

// Detection du navigateur

var bIE = navigator.appName.indexOf("Microsoft") != -1;
var bIE7 = false;
// On fait un cas particulier pour IE7
if (bIE)
{
	var oExpr = new RegExp("MSIE ([0-9])+[\.0-9]*");
	bIE7 = ((oExpr.exec(navigator.userAgent) != null) && (parseInt(oExpr.$1) >= 7));
}

// Encodage des valeurs

function WDEncode (bUTF8)
{
	// On aura besoin de transforme les chaines recus pour gerer les caratere interdit en ISO-8859-1 si besoin
	// Pas besoin de le faire en UTF-8 car il on deja ete encode pour avoir au final la bonne valeur unicode
	if (bUTF8 === undefined)
		bUTF8 = ((document.charset ? document.charset : (document.characterSet ? document.characterSet : "iso-8859-1")).toLowerCase() != "iso-8859-1");

	if (!bUTF8)
	{
		// On defini notre fonction d'encodage des parametres
		this.sEncodePOST = WDEncode.prototype.sEncodePOST_CP1252;

		// Et d'criture de valeur dans le HTML
		this.sEncodeCharset = WDEncode.prototype.sEncodeCharset_CP1252;
	}
	else
	{
		// Le fonctionnement par dfaut des fonctions est OK
		// On defini notre fonction d'encodage des parametres
//		this.sEncodePOST = function (sValeur) { return encodeURIComponent(sValeur); };
		// Et d'criture de valeur dans le HTML
//		this.sEncodeCharset = function (sValeur) { return sValeur; };
	}
};

WDEncode.prototype =
{
	// Fonctionnement par dfaut des fonctions d'encodage : pour les pages UTF8
	// Encodage pour l'criture dans le POST : simple echapement
	sEncodePOST:function (sValeur)
	{
		return encodeURIComponent(sValeur);
	},

	// Encodage pour l'criture dans la page : ne fait rien
	sEncodeCharset:function (sValeur)
	{
		return sValeur;
	},

	// Version pour les pages non UTF8 (CP1252) des fonctions d'encodage
	// Encodage pour l'criture dans le POST : remplacement de tous les caratres unicodes par leur valeur CP1252 si possible
	sEncodePOST_CP1252:function (sValeur)
	{
		// Traite les carateres unicodes
		sValeur = sValeur.replace(/[\u0100-\uFFFF]/g, function(sCar) { var n = sCar.charCodeAt(0); var i; var nLimiteI = WDEncode.prototype.tabConvCP1252.length; for(i = 0; i < nLimiteI; i++){ if(WDEncode.prototype.tabConvCP1252[i] == n) return String.fromCharCode(i + 128);} return sCar; } );
		// Escape le tout
		sValeur = escape(sValeur);
		// Et remplace le + car il represente l'encodage de l'espace
		return sValeur.replace(/\+/g, "%2B");
	},
	
	// Encodage pour l'criture dans la page : remplace les caratres qui ne sont pas dans l'alphabet par leur valeur UNICODE
	sEncodeCharset_CP1252:function (sValeur, bHTML)
	{
		// Le jeu de caratere de windows est CP1252. Qui est un surensemble de ISO-8859-1
		// Il faut convertir tous les carateres entre 0x80 et 0x9F en leur version unicode

		// Puis les caractere de la plage
		// 128 = 0x80
//		if (bHTML)
//			sValeur = sValeur.replace(/[\x80-\x9F]/g, function(sCar) { return "&#" + clWDAJAXMain.sConvCP1252[sCar.charCodeAt(0) - 128] + ";"; } );
//		else
//			sValeur = sValeur.replace(/[\x80-\x9F]/g, function(sCar) { return String.fromCharCode(clWDAJAXMain.sConvCP1252[sCar.charCodeAt(0) - 128]); } );
		sValeur = sValeur.replace(/[\x80-\x9F]/g, function(sCar) { return String.fromCharCode(WDEncode.prototype.tabConvCP1252[sCar.charCodeAt(0) - 128]); } );
		
		if (bHTML)
		{
			// Les caracteres restant (0xA0-0xFF) sont encode normalement en HTML
			sValeur = sValeur.replace(/[\xA0-\xFF]/g, function(sCar) { return "&#" + sCar.charCodeAt(0) + ";"; } );
		}

		// Renvoi de la valeur convertie
		return sValeur;
	},
	
	// Le tableau pour la conversion depuis CP1252
	//							128		129?	130		131		132		133		134		135		136		137		138		139		140		141?	142		143?	144?	145		146		147		148		149		150		151		152		153		154		155		156		157?	158		159
	//							0x80	0x81	0x82	0x83	0x84	0x85	0x86	0x87	0x88	0x89	0x8A	0x8B	0x8C	0x8D	0x8E	0x8F	0x90	0x91	0x92	0x93	0x94	0x95	0x96	0x97	0x98	0x99	0x9A	0x9B	0x9C	0x9D	0x9E	0x9F
	tabConvCP1252:	Array(	8364,	129,	8218,	402,	8222,	8230,	8224,	8225,	710,	8240,	352,	8249,	338,	141,	381,	143,	144,	8216,	8217,	8220,	8221,	8226,	8211,	8212,	732,	8482,	353,	8250,	339,	157,	382,	376),

	// Fonction de reencodage en HTML
	sEncodeInnerHTML:function (sValeur, bRemplaceBR, bPasEncodeBalise)
	{
		// Remplace le minimum de caracteres
		if (!bPasEncodeBalise)
		{
			sValeur = sValeur.replace(/&/g, "&amp;");
			sValeur = sValeur.replace(/</g, "&lt;");
			sValeur = sValeur.replace(/>/g, "&gt;");
//			sValeur = sValeur.replace(/\'/g, "&apos;");
//			sValeur = sValeur.replace(/\"/g, "&quot;");
		}

		// Si le charset de la page est Latin1 (Donc pas en UTF-8)
		// => On transforme les caractere de CP1252 en leur equivalent unicode qui va fonctionner
		// => On encode les autres caracteres > 127
		// Appele le pointeru qui pointe dj sur la bonne fonction
		sValeur = this.sEncodeCharset(sValeur, true);

		if (bRemplaceBR)
		{
			// Met des balises BR pour les marques de lignes
			sValeur = sValeur.replace(/\r\n/g, "<BR>");
			sValeur = sValeur.replace(/\n/g, "<BR>");
		}

		// Renvoi de la valeur
		return sValeur;
	}
}

// Instancie un objet principal
var clWDEncode = new WDEncode(_bUTF8_);
